

const API_URL = "https://script.google.com/macros/s/AKfycbzicGD3r8gQy94WPFwlLNedkIu41F5J6XKpmSbcotuhZT9i1yh2yAumIn7fTtvuhNSzhw/exec";

// TAB switching
document.querySelectorAll(".ecom-tab").forEach(btn => {
  btn.addEventListener("click", () => {
    const target = btn.dataset.target;

    document.querySelectorAll(".ecom-tab").forEach(b => b.classList.remove("active"));
    document.querySelectorAll(".ecom-panel").forEach(p => p.classList.remove("active"));

    btn.classList.add("active");
    document.getElementById(target).classList.add("active");
  });
});
document.addEventListener("DOMContentLoaded", loadEcommerce);
// LOAD DATA
async function loadEcommerce() {
  try {
    const res = await fetch(API_URL);
    const data = await res.json();

    const panels = {
      Home_Cleaning: document.getElementById("Home_Cleaning"),
      General_Cleaning: document.getElementById("General_Cleaning"),
      Deep_Cleaning: document.getElementById("Deep_Cleaning"),
      Rental_Crane: document.getElementById("Rental_Crane"),
      Fabric_Cleaning: document.getElementById("Fabric_Cleaning"),
    };

    Object.values(panels).forEach(p => p.innerHTML = "");

    data.forEach(item => {
      const cat = item.kategori.replace(" ", "_");
      const panel = panels[cat];
      if (!panel) return;

      const harga = Number(item.harga).toLocaleString("id-ID");
        const diskonRaw = Number(item["harga diskon"]);
        const adaDiskon = diskonRaw && diskonRaw > 0;
        const diskon = adaDiskon ? diskonRaw.toLocaleString("id-ID") : null;


     panel.innerHTML += `
  <div class="ecom-card">
    

    <div class="ecom-name">${item.namaPaket}</div>
    <div class="ecom-desc">${item.deskripsi}</div>

    <div class="ecom-price-box">
      ${adaDiskon
        ? `
          <div class="ecom-diskon">Rp ${diskon}</div>
          <div class="ecom-asli">Rp ${harga}</div>
        `
        : `
          <div class="ecom-normal-only">Rp ${harga}</div>
        `
      }
    </div>

    <div class="ecom-meta">
      Durasi: ${item.durasi} <br>
      Petugas: ${item.petugas}
    </div>

    <a class="ecom-btn" onclick="openOrder(
  '${item.namaPaket}',
  '${diskon ? diskon : harga}'
)">Pesan Sekarang
    </a>
  </div>
`;

    });

   } catch(err) {
    console.error("Gagal menyimpan data (POST):", err);
    alert("Terjadi kesalahan saat mengirim pesanan. Silakan coba lagi.");
  }
}

loadEcommerce();


const FORM_API = API_URL;

document.getElementById("orderForm").addEventListener("submit", async (e) => {
  e.preventDefault();

  const data = {
    nama: document.getElementById("custNama").value,
    wa: document.getElementById("custWA").value,
    alamat: document.getElementById("custAlamat").value,
    paket: document.getElementById("paketNama").value,
    harga: document.getElementById("paketHarga").value
  };

  // SIMPAN KE GOOGLE SHEET
  await fetch(FORM_API, {
    method: "POST",
    body: JSON.stringify(data)
  });

  // KIRIM WA ADMIN
  const admin = "6285358888599";
  const pesan = `
PESANAN BARU:
Nama: ${data.nama}
WA: ${data.wa}
Alamat: ${data.alamat}
Paket: ${data.paket}
Harga: Rp ${data.harga}
  `;

  window.location.href =
    "https://wa.me/" + admin + "?text=" + encodeURIComponent(pesan);

  closeOrder();
});

function openOrder(namaPaket, harga) {
  document.getElementById("paketNama").value = namaPaket;
  document.getElementById("paketHarga").value = harga;

  document.getElementById("summaryName").innerText = namaPaket;
  document.getElementById("summaryPrice").innerText = "Rp " + harga.toLocaleString("id-ID");

  document.getElementById("orderModal").classList.add("show");
}
function closeOrder() {
  document.getElementById("orderModal").classList.remove("show");
}

